# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from ..sdapiobject import SDAPIObject
from ..sdproperty import SDProperty
from ..sdtexture import SDTexture
from ..sdgraph import SDGraph
from ..sdapiobject import SDApiError
from ..sdproperty import SDPropertyCategory
from ..sdproperty import SDPropertyInheritanceMethod
from ..sdtexture import SBSPixelFormat
from ..apiexception import APIException

class SDSBSCompGraph(SDGraph):
    """
    Class managing a Substance compositing graph
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDSBSCompGraph
        """
        super(SDSBSCompGraph, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(parent : SDAPIObject) -> SDSBSCompGraph:
        """
        Create a new SDSBSCompGraph under the specified parent

        :param parent: The parent data that will contains the newly created compositing graph. Can be SDPackage or SDResourceFolder
        """
        outResource = ctypes.c_void_p()
        _res = sd.getContext().SDSBSCompGraph_sNew(parent.mHandle, ctypes.byref(outResource))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outResource, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outResource.value, ownHandle=True)

    def compute(self) -> None:
        """
        Compute the SBSGraph. Ensure all graph outputs textures are available and up to date. This function blocks the execution until completion

        """
        _res = self.mAPIContext.SDSBSCompGraph_compute(self.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getPropertyInheritanceMethod(self, sdProperty : SDProperty) -> SDPropertyInheritanceMethod:
        """
        For graph properties that support it, retrieve the inheritance method of the specified property. See 'SDPropertyInheritanceMethod'

        :param sdProperty: The property we want to query the inheritance method
        """
        outInheritanceMethod = ctypes.c_int()
        _res = self.mAPIContext.SDSBSCompGraph_getPropertyInheritanceMethod(self.mHandle, sdProperty.mHandle, ctypes.byref(outInheritanceMethod))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return SDPropertyInheritanceMethod(outInheritanceMethod.value)

    def setPropertyInheritanceMethod(self, sdProperty : SDProperty, inheritanceMethod : SDPropertyInheritanceMethod) -> None:
        """
        For graph properties that support it, set the inheritance method of the specified property. See 'SDPropertyInheritanceMethod'

        :param sdProperty: The property we want to set the inheritance method
        :param inheritanceMethod: The inheritance method to set on the property
        """
        _res = self.mAPIContext.SDSBSCompGraph_setPropertyInheritanceMethod(self.mHandle, sdProperty.mHandle, inheritanceMethod.value)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getUID(self) -> str:
        """
        Helper used to get the UID of the graph

        """
        outUID = ctypes.c_char_p()
        _res = self.mAPIContext.SDSBSCompGraph_getUID(self.mHandle, ctypes.byref(outUID))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outUID.value.decode('utf-8') # type: ignore

    def getGraphType(self) -> str:
        """
        Helper used to get the type of the graph

        """
        outGraphType = ctypes.c_char_p()
        _res = self.mAPIContext.SDSBSCompGraph_getGraphType(self.mHandle, ctypes.byref(outGraphType))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outGraphType.value.decode('utf-8') # type: ignore

    def getExposedInSBSAR(self) -> bool:
        """
        Return True if the graph is exposed in SBSAR

        """
        outExposedInSBSAR = ctypes.c_bool()
        _res = self.mAPIContext.SDSBSCompGraph_getExposedInSBSAR(self.mHandle, ctypes.byref(outExposedInSBSAR))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outExposedInSBSAR.value

    def getIcon(self) -> Optional[SDTexture]:
        """
        Helper used to get the icon of the graph

        """
        outSDTexture = ctypes.c_void_p()
        _res = self.mAPIContext.SDSBSCompGraph_getIcon(self.mHandle, ctypes.byref(outSDTexture))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDTexture, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDTexture.value, ownHandle=True)

    def setIcon(self, sdTexture : SDTexture) -> None:
        """
        Helper used to set the icon of the graph

        :param sdTexture: The texture that will be used as icon
        """
        _res = self.mAPIContext.SDSBSCompGraph_setIcon(self.mHandle, sdTexture.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

